/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.block;

import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.blay09.mods.waystones.Waystones;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.PlayerWaystoneManager;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntity;
import net.blay09.mods.waystones.tileentity.WaystoneTileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class WaystoneBlock
extends WaystoneBlockBase {
    private static final VoxelShape LOWER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)WaystoneBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), (VoxelShape[])new VoxelShape[]{WaystoneBlock.func_208617_a((double)1.0, (double)3.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0), WaystoneBlock.func_208617_a((double)2.0, (double)7.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), WaystoneBlock.func_208617_a((double)3.0, (double)9.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)}).func_197753_c();
    private static final VoxelShape UPPER_SHAPE = VoxelShapes.func_216384_a((VoxelShape)WaystoneBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0), (VoxelShape[])new VoxelShape[]{WaystoneBlock.func_208617_a((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), WaystoneBlock.func_208617_a((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), WaystoneBlock.func_208617_a((double)3.0, (double)12.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0), WaystoneBlock.func_208617_a((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)}).func_197753_c();

    public WaystoneBlock() {
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)HALF, (Comparable)DoubleBlockHalf.LOWER)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b((Property)HALF) == DoubleBlockHalf.UPPER ? UPPER_SHAPE : LOWER_SHAPE;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new WaystoneTileEntity();
    }

    @Override
    protected void handleActivation(World world, BlockPos pos, PlayerEntity player, WaystoneTileEntityBase tileEntity, IWaystone waystone) {
        boolean isActivated = PlayerWaystoneManager.isWaystoneActivated(player, waystone);
        if (isActivated) {
            if (!world.field_72995_K) {
                if (((Boolean)WaystonesConfig.COMMON.allowWaystoneToWaystoneTeleport.get()).booleanValue()) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)tileEntity.getWaystoneSelectionContainerProvider(), it -> {
                        it.writeByte(WarpMode.WAYSTONE_TO_WAYSTONE.ordinal());
                        it.func_179255_a(pos);
                    });
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.waystones.waystone_to_waystone_disabled"), true);
                }
            }
        } else {
            PlayerWaystoneManager.activateWaystone(player, waystone);
            if (!world.field_72995_K) {
                StringTextComponent nameComponent = new StringTextComponent(waystone.getName());
                nameComponent.func_240699_a_(TextFormatting.WHITE);
                TranslationTextComponent chatComponent = new TranslationTextComponent("chat.waystones.waystone_activated", new Object[]{nameComponent});
                chatComponent.func_240699_a_(TextFormatting.YELLOW);
                player.func_145747_a((ITextComponent)chatComponent, Util.field_240973_b_);
                WaystoneSyncManager.sendActivatedWaystones(player);
            }
            this.notifyObserversOfAction(world, pos);
            if (world.field_72995_K) {
                Waystones.proxy.playSound(SoundEvents.field_187802_ec, pos, 1.0f);
                for (int i = 0; i < 32; ++i) {
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 3), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                    world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, (double)(pos.func_177956_o() + 4), (double)pos.func_177952_p() + 0.5 + (world.field_73012_v.nextDouble() - 0.5) * 2.0, 0.0, -5.0, 0.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        if (!((Boolean)WaystonesConfig.CLIENT.disableParticles.get()).booleanValue() && random.nextFloat() < 0.75f) {
            TileEntity tileEntity = world.func_175625_s(pos);
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (tileEntity instanceof WaystoneTileEntity && PlayerWaystoneManager.isWaystoneActivated((PlayerEntity)Objects.requireNonNull(player), ((WaystoneTileEntity)tileEntity).getWaystone())) {
                world.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
                world.func_195594_a((IParticleData)ParticleTypes.field_197623_p, (double)pos.func_177958_n() + 0.5 + (random.nextDouble() - 0.5) * 1.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5 + (random.nextDouble() - 0.5) * 1.5, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{HALF});
    }
}

